
function GetPluginSettings()
{
	// Generting dependency string;
	var dependency_str = "";

	return {
		"name":			"Valerypopoff Ease",				// as appears in 'insert object' dialog, can be changed as long as "id" stays the same
		"id":			"ValerypopoffEase",				// this is used to identify this plugin and is saved to the project; never change it
		"version":		"2.0.0",					// (float in x.y format) Plugin version - C2 shows compatibility warnings based on this
		"description":	"Ease any Construct values with different easing effects.",
		"author":		"Valera Popov",
		"help url":		"http://valerypopoff.ru/construct/ease-plugin/",
		"category":		"General",				// Prefer to re-use existing categories, but you can set anything here

		// Ignore this: yes	
		"type":			"object",


		"flags":		pf_singleglobal						
					// uncomment lines to enable flags...
					//	| pf_singleglobal		// exists project-wide, e.g. mouse, keyboard.  "type" must be "object".
					//	| pf_texture			// object has a single texture (e.g. tiled background)
					//	| pf_position_aces		// compare/set/get x, y...
					//	| pf_size_aces			// compare/set/get width, height...
					//	| pf_angle_aces			// compare/set/get angle (recommended that "rotatable" be set to true)
					//	| pf_appearance_aces	// compare/set/get visible, opacity...
					//	| pf_tiling				// adjusts image editor features to better suit tiled images (e.g. tiled background)
					//	| pf_animations			// enables the animations system.  See 'Sprite' for usage
					//	| pf_zorder_aces		// move to top, bottom, layer...
					//  | pf_nosize				// prevent resizing in the editor
					//	| pf_effects			// allow WebGL shader effects to be added
					//  | pf_predraw			// set for any plugin which draws and is not a sprite (i.e. does not simply draw
												// a single non-tiling image the size of the object) - required for effects to work properly
		,"rotatable":	false					// only used when "type" is "world".  Enables an angle property on the object.
		,"dependency":	dependency_str
	};
};

////////////////////////////////////////
// Parameter types:
// AddNumberParam(label, description [, initial_string = "0"])			// a number
// AddStringParam(label, description [, initial_string = "\"\""])		// a string
// AddAnyTypeParam(label, description [, initial_string = "0"])			// accepts either a number or string
// AddCmpParam(label, description)										// combo with equal, not equal, less, etc.
// AddComboParamOption(text)											// (repeat before "AddComboParam" to add combo items)
// AddComboParam(label, description [, initial_selection = 0])			// a dropdown list parameter
// AddObjectParam(label, description)									// a button to click and pick an object type
// AddLayerParam(label, description)									// accepts either a layer number or name (string)
// AddLayoutParam(label, description)									// a dropdown list with all project layouts
// AddKeybParam(label, description)										// a button to click and press a key (returns a VK)
// AddAnimationParam(label, description)								// a string intended to specify an animation name
// AddAudioFileParam(label, description)								// a dropdown list with all imported project audio files

////////////////////////////////////////
// Conditions

// AddCondition(id,					// any positive integer to uniquely identify this condition
//				flags,				// (see docs) cf_none, cf_trigger, cf_fake_trigger, cf_static, cf_not_invertible,
//									// cf_deprecated, cf_incompatible_with_triggers, cf_looping
//				list_name,			// appears in event wizard list
//				category,			// category in event wizard list
//				display_str,		// as appears in event sheet - use {0}, {1} for parameters and also <b></b>, <i></i>
//				description,		// appears in event wizard dialog when selected
//				script_name);		// corresponding runtime function name
				
// example				
//AddNumberParam("Number", "Enter a number to test if positive.");
//AddCondition(0, cf_none, "Is number positive", "My category", "{0} is positive", "Description for my condition!", "MyCondition");

////////////////////////////////////////
// Actions

// AddAction(id,				// any positive integer to uniquely identify this action
//			 flags,				// (see docs) af_none, af_deprecated
//			 list_name,			// appears in event wizard list
//			 category,			// category in event wizard list
//			 display_str,		// as appears in event sheet - use {0}, {1} for parameters and also <b></b>, <i></i>
//			 description,		// appears in event wizard dialog when selected
//			 script_name);		// corresponding runtime function name

// example
//AddStringParam("Message", "Enter a string to alert.");
//AddAction(0, af_none, "Alert", "My category", "Alert {0}", "Description for my action!", "MyAction");

////////////////////////////////////////
// Expressions

// AddExpression(id,			// any positive integer to uniquely identify this expression
//				 flags,			// (see docs) ef_none, ef_deprecated, ef_return_number, ef_return_string,
//								// ef_return_any, ef_variadic_parameters (one return flag must be specified)
//				 list_name,		// currently ignored, but set as if appeared in event wizard
//				 category,		// category in expressions panel
//				 exp_name,		// the expression name after the dot, e.g. "foo" for "myobject.foo" - also the runtime function name
//				 description);	// description in expressions panel

// example
//AddExpression(0, ef_return_number, "Leet expression", "My category", "MyExpression", "Return the number 1337.");


// Actions
//-------------------------------------------------

AddStringParam("Tick function name", "Construct tick-function name. Instead of easing an object's or a system value directly, plugin eases a virtual value and passed it as a parameter to a function that's being called every tick. Address this parameter from within a function with expression \"Function.Param(0)\"."
);	

AddNumberParam("Start value", "Start value."
, "0"
);	

AddNumberParam("End value", "End value."
, "100"
);	

AddNumberParam("Duration", "Easing duration (in seconds)."
, "1"
);	

AddComboParamOption("Linear");
AddComboParamOption("Quadratic in");
AddComboParamOption("Quadratic out");
AddComboParamOption("Quadratic in/out");
AddComboParamOption("Cubic in");
AddComboParamOption("Cubic out");
AddComboParamOption("Cubic in/out");
AddComboParamOption("Quartic in");
AddComboParamOption("Quartic out");
AddComboParamOption("Quartic in/out");
AddComboParamOption("Quintic in");
AddComboParamOption("Quintic out");
AddComboParamOption("Quintic in/out");
AddComboParamOption("Sinusoidal in");
AddComboParamOption("Sinusoidal out");
AddComboParamOption("Sinusoidal in/out");
AddComboParamOption("Exponential in");
AddComboParamOption("Exponential out");
AddComboParamOption("Exponential in/out");
AddComboParamOption("Circular in");
AddComboParamOption("Circular out");
AddComboParamOption("Circular in/out");
AddComboParamOption("Custom JS easing function");
AddComboParamOption("Custom Construct easing function");
AddComboParam("Easing effect", "Easing effect."
, 1
);	

AddComboParamOption("Disable");
AddComboParamOption("Enable");
AddComboParam("Bounce back", "Bounce back effect."
, 1
);	

AddAction(0, af_none, "Ease", "General", "Ease {0} from {1} to {2} in {3} sec. with effect: {4}. Bounce: {5}", "Start easing.", "Ease");


AddStringParam("JS code", "Provide JS code for the easing function body. Assume that the function gets 4 parameters: 'curr_time', 'start_value', 'delta' (change in value) and 'duration'. Function must return a calculated current value."
, "\"return delta * curr_time / duration + start_value\""
);	

AddAction(1, af_none, "Set custom JS easing function", "Programming", "Set {0} as a custom easing function", "Set custom JS easing function.", "SetCustomJS");


AddStringParam("Construct function name", "Provide the name of a Construct function that returns a calculated current value based on 4 passed parameters: current time, start value, change in value (delta), duration."
);	

AddAction(2, af_none, "Set custom Construct easing function", "Programming", "Set {0} as a custom easing function", "Set custom Construct easing function.", "SetCustomConstruct");


AddStringParam("Tick function name", "Construct tick-function."
);	

AddAction(3, af_none, "Pause", "General", "Pause {0}", "Pause easing.", "Pause");


AddStringParam("Tick function name", "Construct tick-function name."
);	

AddAction(4, af_none, "Resume", "General", "Resume  {0}", "Resume easing.", "Resume");


AddStringParam("Tick function name", "Construct tick-function name."
);	

AddAction(5, af_none, "Terminate", "General", "Terminate  {0}", "Terminate easing.", "Terminate");


// Conditions
//-------------------------------------------------

AddStringParam("Tick function name", "Construct tick-function."
);	

AddCondition(0, cf_none, "In Progress", "General", "{0} in progress", "Check if easing is in progress (even if paused).", "InProgress");


AddStringParam("Tick function name", "Construct tick-function."
);	

AddCondition(1, cf_trigger, "On finished", "General", "{0} is finished", "Triggered when easing is finished.", "OnFinished");


AddStringParam("Tick function name", "Construct tick-function."
);	

AddCondition(2, cf_none, "Paused", "General", "{0} is paused", "Check if the easing is paused.", "Paused");


// Expressions
//-------------------------------------------------

AddStringParam("Tick function name", "Construct tick-function name."
);	

AddExpression(0, ef_return_number, "Time Progress", "General", "TimeProgress", "Get the easing time progress.");

AddStringParam("Tick function name", "Construct tick-function name."
);	

AddExpression(1, ef_return_number, "Current Value", "General", "CurrentValue", "Get the current value.");




ACESDone();

////////////////////////////////////////
// Array of property grid properties for this plugin
// new cr.Property(ept_integer,		name,	initial_value,	description)		// an integer value
// new cr.Property(ept_float,		name,	initial_value,	description)		// a float value
// new cr.Property(ept_text,		name,	initial_value,	description)		// a string
// new cr.Property(ept_color,		name,	initial_value,	description)		// a color dropdown
// new cr.Property(ept_font,		name,	"Arial,-16", 	description)		// a font with the given face name and size
// new cr.Property(ept_combo,		name,	"Item 1",		description, "Item 1|Item 2|Item 3")	// a dropdown list (initial_value is string of initially selected item)
// new cr.Property(ept_link,		name,	link_text,		description, "firstonly")		// has no associated value; simply calls "OnPropertyChanged" on click

var property_list = [
	];
	
	
// Called by IDE when a new object type is to be created
function CreateIDEObjectType()
{
	return new IDEObjectType();
}

// Class representing an object type in the IDE
function IDEObjectType()
{
	assert2(this instanceof arguments.callee, "Constructor called as a function");
}

// Called by IDE when a new object instance of this type is to be created
IDEObjectType.prototype.CreateInstance = function(instance)
{
	return new IDEInstance(instance);
}

// Class representing an individual instance of an object in the IDE
function IDEInstance(instance, type)
{
	assert2(this instanceof arguments.callee, "Constructor called as a function");
	
	// Save the constructor parameters
	this.instance = instance;
	this.type = type;
	
	// Set the default property values from the property table
	this.properties = {};
	
	for (var i = 0; i < property_list.length; i++)
		this.properties[property_list[i].name] = property_list[i].initial_value;
		
	// Plugin-specific variables
	// this.myValue = 0...
}

// Called when inserted via Insert Object Dialog for the first time
IDEInstance.prototype.OnInserted = function()
{
}

// Called when double clicked in layout
IDEInstance.prototype.OnDoubleClicked = function()
{
}

// Called after a property has been changed in the properties bar
IDEInstance.prototype.OnPropertyChanged = function(property_name)
{
}

// For rendered objects to load fonts or textures
IDEInstance.prototype.OnRendererInit = function(renderer)
{
}

// Called to draw self in the editor if a layout object
IDEInstance.prototype.Draw = function(renderer)
{
}

// For rendered objects to release fonts or textures
IDEInstance.prototype.OnRendererReleased = function(renderer)
{
}